require 'page-object'

class UserMenuOption
  include PageObject

  button(:userMenu, :id => 'user-menu-btn')
  h3(:title, :css => '.menu-header')
  button(:about, :id => 'about-btn')
  button(:help, :id=>'help-btn')
  button(:feedback, :id => 'feedback-btn')
  button(:preferences, :id => 'preferences-btn')
  link(:launchpad, :id => 'launchpad-btn')
  link(:logOut, :id => 'logout-btn')
  div(:userMenu_panel, :css => '.panel-menu')

  expected_title "User Menu"

  #About page
  h2(:aboutTitle, :css => '#about-popup .ui-title')
  h3(:appVersion, :id => 'version')
  p(:contentLine1, :css => '#about-popup .ui-popup p:nth-of-type(1)')
  li(:contentLine2, :css => '#about-popup .ui-popup ul li:nth-of-type(1)')
  li(:contentLine3, :css => '#about-popup .ui-popup ul li:nth-of-type(2)')
  li(:contentLine4, :css => '#about-popup .ui-popup ul li:nth-of-type(3)')
  button(:ok, :id => 'about-ok-btn')

  #Preferences Menu
  h2(:prefTitle, :css => '#preferences-popup .ui-title')
  p(:required, :css => '#preferences-popup .ui-popup p:nth-of-type(1)')
  div(:content, :css => '#email-preferences-form .email-preferences-section')
  div(:text, :css => 'ui-controlgroup-label')
  button(:prefSave, :id => 'preferences-save-btn')
  button(:prefCancel, :id => 'preferences-cancel-btn')
  radio_button_group(:emailPref, :name=>'modal-emailAllowed')
  text_field(:email, :id => 'modal-emailAddress')

  #h3(:errorSummaryHeader, :id => 'error-list-heading h3')

  #TODO
  #Help Menu
  link(:appStoreLink, :css=>'a[href="https://mobile.DOMAIN.EX/appstore"]')
  link(:facilityLocatorLink, :css=>'a[href="https://www.DOMAIN.EX/directory/guide/division.asp?dnum=1"]')
  link(:userGuideLink, :css => 'a[href="app/modules/user-guide/Veteran_Appointment_Request_UG.pdf"]')

  def clickUserMenu
    wait_until{ !userMenu_element.attribute('disabled') }
    userMenu_element.when_present(TIME_OUT_LIMIT)
    userMenu
  end

  def clickFeedback
    wait_until{ !feedback_element.attribute('disabled') }
    feedback_element.when_present(TIME_OUT_LIMIT)
    feedback
  end
end
TT